#ifndef PLAYRECORD_H
#define PLAYRECORD_H

#include "dac.h"
#include "adc.h"
#include "wav.h"
#include "ff.h"

#define MAX_PATH_NAME		255
#define MAX_FILE_NAME		16
#define DISP_VOLUME			0
#define DISP_SAMPLERATE		1

#define DISP_MAX			1

extern FATFS		fileSystem;
extern FIL			fsrc;
extern FIL 			fdst;
extern WAVHeader 	header;
extern char			pathName[MAX_PATH_NAME];
extern char 		fileName0[MAX_FILE_NAME+1];
extern char 		fileName1[MAX_FILE_NAME+1];
extern char 		fileName2[MAX_FILE_NAME+1];
extern unsigned int minutesElapsed;
extern unsigned int secondsElapsed;
extern int randomPlay;

void initFF(void);
int playHelperID(int);
int playCallBack(int);
int playMinimalCallBack(int);
int recordCallBack(int);
int isWAVFile(char *path);
int  playWAVFile(char*, int (*)(int), unsigned long);
int  recordWAVFile(char*, int (*)(int), unsigned long);
int  playCallBackId(int);
int getDirectoryEntry(char*, int, char*, int);
int getNextDirectoryEntry(char*, char*, int);
int enterDirectory(char*, int*, int, void (*)(int, char*));
char* selectFile(char*, int*, int*, int, void (*)(int, char*));
char* stripFileName(char*);
unsigned long getTotalKiloBytes(void);
unsigned long getFreeKiloBytes(void);
void displayCallBackLCD(int, char*);
void displayCallBackOLED(int, char*);
int countEntries(char*);
char* getRandomTrack(char*, int);

#endif
